# Walk-in Customer Logic and Live Stock Updates in POS

## Current Work
Implementing walk-in customer support in the POS dashboard to allow sales without an existing customer record, and adding live client-side stock updates in the product grid when items are added or quantities changed in the invoice.

## Key Technical Concepts
- Laravel Eloquent models (Customer, Sale, Product).
- Select2 for dynamic customer search with custom "Walk-in" option.
- JavaScript for client-side logic: handling walk-in selection, null customer_id in form submission, and updating product card stock displays based on invoice quantities.
- Validation in PosController::store made nullable for customer_id.
- No database changes; use null for anonymous sales.

## Relevant Files and Code
- app/Http/Controllers/PosController.php: Update store method validation and logic for null customer_id.
- resources/views/pos/dashboard.blade.php: Add walk-in option to Select2, modify addProduct to allow walk-in, set customer_id to null in submitForm, add JS functions to update stock displays in product cards (using data-current-stock and recalculating remaining stock = initial - invoice qty).

## Problem Solving
- Current validation requires customer_id; make nullable and skip customer-specific logic (e.g., due calculations) for walk-in.
- Stock updates are client-side only for live display; actual DB update on sale completion.
- Ensure no errors when customer_id is null in Sale model creation.

## Pending Tasks and Next Steps
- [x] Step 1: Edit app/Http/Controllers/PosController.php to make 'customer_id' nullable in validation. If null, skip customer lookup and set a default name like "Walk-in Customer" in the sale record if needed. Quote from conversation: "implement walk-in customer logic in the pos area".
- [x] Step 2: Edit resources/views/pos/dashboard.blade.php to add "Walk-in Customer" as a default option in #customerSelect Select2 (value='walk_in'). Modify addProduct to check if value === 'walk_in' or existing customer. In submitForm, if 'walk_in', set customerId = null. Add JS to track invoice quantities per product and update .stock-display in product cards on addProduct, changeQuantity, removeItem (remaining = data-current-stock - total invoice qty for that product). Quote from conversation: "when i select product should update the stock live" and "should update current stock on that moment".
- [x] Step 3: Test the implementation: Run server, navigate to /pos/dashboard, select walk-in, add products (verify stock updates live), submit sale (verify no errors, sale recorded with null customer_id).
- [x] Step 4: If issues, debug and fix (e.g., check Sale model fillable for customer_id nullable).
